/* exported mc_send_box_basic_date */
/* exported mc_set_hardware_connection_library */
/* exported mc_read_hardware_date */

/* global mc_sdk_param */
/* global $ */

var JSON_PAPRAM_GET = "GET_PARAM";
var JSON_PAPRAM_SET = "SET_PARAM";

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置硬件链接库
 * 参数:
 *    @param {Promise<function>} fun_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.3.18
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_set_hardware_connection_library(str_time, fun_callback) {
    if ("function" !== typeof (fun_callback)) {
        return;
    }
    if ("string" !== typeof str_time || 0 >= str_time.length) {
        str_time = "5000";
    }
    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("HW_CONNECT_LIB");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_SET);
    obj_sdk_param_req.set_param_value("FILE", "");
    obj_sdk_param_req.set_attr_val("FILE", "BLOCK_MS", str_time);
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        fun_callback();
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取硬件数据
 * 参数:
 *    @param {Promise<function>} fun_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.3.18
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_read_hardware_date(fun_callback) {
    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("HW_CONNECT_INFO");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_GET);

    // $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
    //     if ("success" !== status) {
    //         return;
    //     }
    //     fun_callback(_response);
    // }, "text");
    $.ajax({
        type: "POST",
        url: "/access_shell",
        data: obj_sdk_param_req.get_json(),
        headers: {
            "Cache-Control": "must-revalidate, post-check=0, pre-check=0"
        },
        success: function (response, status) {
            if ("success" !== status) {
                return;
            }
            fun_callback(response);
        }

    });
}
